# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Initial move: Cooperate to signal willingness for mutual cooperation
    
    opponent_code_lower = opponent_program_code.lower()
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Late-game adjustment: defect in last 2 rounds if opponent defected more than twice
    if current_round >= total_rounds - 1:
        if opp_history.count("D") > 2:
            return "D"
    
    # Tit-for-tat with forgiveness
    if opp_history[-1] == "C":
        # Cooperate unless opponent has a pattern of exploiting us
        if len(opp_history) >= 2 and opp_history[-2] == "D" and my_history[-1] == "C":
            return "D"
        return "C"
    else:
        # Defect if opponent defected last round, but forgive after one retaliation
        if len(my_history) >= 2 and my_history[-1] == "D" and opp_history[-2] == "D":
            return "C"
        return "D"